@extends('admin.layouts.app')

@section('title', 'Dashboard Admin')
@section('page-title', 'Dashboard')
@section('page-subtitle', 'Selamat datang di Admin Panel')

@section('content')
<div class="space-y-6">
    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Total Karyawan -->
        <div class="bg-white rounded-2xl shadow-sm p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 font-medium">Total Karyawan</p>
                    <p class="text-3xl font-bold text-gray-800 mt-2">{{ $totalKaryawan ?? 0 }}</p>
                    <p class="text-xs text-green-600 mt-2">
                        <i class="fas fa-arrow-up"></i> Aktif
                    </p>
                </div>
                <div class="w-14 h-14 rounded-full bg-blue-100 flex items-center justify-center">
                    <i class="fas fa-users text-2xl text-blue-600"></i>
                </div>
            </div>
        </div>

        <!-- Hadir Hari Ini -->
        <div class="bg-white rounded-2xl shadow-sm p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 font-medium">Hadir Hari Ini</p>
                    <p class="text-3xl font-bold text-gray-800 mt-2">{{ $hadirHariIni ?? 0 }}</p>
                    <p class="text-xs text-gray-500 mt-2">dari {{ $totalKaryawan ?? 0 }} karyawan</p>
                </div>
                <div class="w-14 h-14 rounded-full bg-green-100 flex items-center justify-center">
                    <i class="fas fa-check-circle text-2xl text-green-600"></i>
                </div>
            </div>
        </div>

        <!-- Terlambat -->
        <div class="bg-white rounded-2xl shadow-sm p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 font-medium">Terlambat</p>
                    <p class="text-3xl font-bold text-gray-800 mt-2">{{ $terlambatHariIni ?? 0 }}</p>
                    <p class="text-xs text-yellow-600 mt-2">hari ini</p>
                </div>
                <div class="w-14 h-14 rounded-full bg-yellow-100 flex items-center justify-center">
                    <i class="fas fa-clock text-2xl text-yellow-600"></i>
                </div>
            </div>
        </div>

        <!-- Absensi Bulan Ini -->
        <div class="bg-white rounded-2xl shadow-sm p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 font-medium">Total Absensi</p>
                    <p class="text-3xl font-bold text-gray-800 mt-2">{{ $totalAbsensiBulanIni ?? 0 }}</p>
                    <p class="text-xs text-gray-500 mt-2">bulan ini</p>
                </div>
                <div class="w-14 h-14 rounded-full bg-orange-100 flex items-center justify-center">
                    <i class="fas fa-calendar-check text-2xl text-orange-600"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Absensi Terbaru -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="p-6 border-b border-gray-100">
                <h3 class="text-lg font-bold text-gray-800">Absensi Terbaru</h3>
                <p class="text-sm text-gray-500">Hari ini</p>
            </div>
            <div class="p-6">
                @if(isset($recentAbsensi) && $recentAbsensi->count() > 0)
                    <div class="space-y-4">
                        @foreach($recentAbsensi as $absensi)
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 rounded-full gradient-orange flex items-center justify-center text-white font-semibold">
                                    {{ substr($absensi->karyawan->user->nama, 0, 1) }}
                                </div>
                                <div>
                                    <p class="font-semibold text-gray-800">{{ $absensi->karyawan->user->nama }}</p>
                                    <p class="text-sm text-gray-500">{{ $absensi->karyawan->jabatan->nama_jabatan ?? '-' }}</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-semibold text-gray-800">{{ date('H:i', strtotime($absensi->jam_masuk)) }}</p>
                                <span class="text-xs px-2 py-1 rounded-full {{ $absensi->status === 'hadir' ? 'bg-green-100 text-green-700' : 'bg-yellow-100 text-yellow-700' }}">
                                    {{ ucfirst($absensi->status) }}
                                </span>
                            </div>
                        </div>
                        @endforeach
                    </div>
                @else
                    <p class="text-center text-gray-400 py-8">Belum ada absensi hari ini</p>
                @endif
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="p-6 border-b border-gray-100">
                <h3 class="text-lg font-bold text-gray-800">Quick Actions</h3>
                <p class="text-sm text-gray-500">Aksi cepat</p>
            </div>
            <div class="p-6 grid grid-cols-2 gap-4">
                <a href="{{ route('admin.karyawan.index') }}" class="flex flex-col items-center justify-center p-6 bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl hover:shadow-md transition group">
                    <div class="w-12 h-12 bg-blue-500 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition">
                        <i class="fas fa-user-plus text-white text-xl"></i>
                    </div>
                    <p class="text-sm font-semibold text-gray-800">Tambah Karyawan</p>
                </a>

                <a href="{{ route('admin.jabatan.index') }}" class="flex flex-col items-center justify-center p-6 bg-gradient-to-br from-green-50 to-green-100 rounded-xl hover:shadow-md transition group">
                    <div class="w-12 h-12 bg-green-500 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition">
                        <i class="fas fa-briefcase text-white text-xl"></i>
                    </div>
                    <p class="text-sm font-semibold text-gray-800">Tambah Jabatan</p>
                </a>

                <a href="{{ route('admin.absensi.index') }}" class="flex flex-col items-center justify-center p-6 bg-gradient-to-br from-orange-50 to-orange-100 rounded-xl hover:shadow-md transition group">
                    <div class="w-12 h-12 bg-orange-500 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition">
                        <i class="fas fa-clipboard-list text-white text-xl"></i>
                    </div>
                    <p class="text-sm font-semibold text-gray-800">Lihat Absensi</p>
                </a>

                {{-- <a href="{{ route('admin.gaji.index') }}" class="flex flex-col items-center justify-center p-6 bg-gradient-to-br from-purple-50 to-purple-100 rounded-xl hover:shadow-md transition group">
                    <div class="w-12 h-12 bg-purple-500 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition">
                        <i class="fas fa-money-bill-wave text-white text-xl"></i>
                    </div>
                    <p class="text-sm font-semibold text-gray-800">Kelola Gaji</p>
                </a> --}}
            </div>
        </div>
    </div>
</div>
@endsection
